/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.permissions.register;

import java.util.Optional;
import java.util.function.Supplier;
import net.impactdev.impactor.api.platform.plugins.PluginMetadata;
import net.impactdev.impactor.api.services.permissions.PermissionsService;

public final class PermissionsRegistrationProvider {
    private PermissionServiceSuggestion suggestion;

    public PermissionServiceSuggestion suggestion() {
        return Optional.ofNullable(this.suggestion).orElseThrow(() -> new IllegalStateException("No suggestions available"));
    }

    public void suggest(PluginMetadata metadata, int priority, Supplier<PermissionsService> supplier) {
        if (this.suggestion == null || this.suggestion.priority() < priority) {
            this.suggestion = this.createSuggestion(metadata, priority, supplier);
        }
    }

    private PermissionServiceSuggestion createSuggestion(PluginMetadata metadata, int priority, Supplier<PermissionsService> supplier) {
        return new PermissionServiceSuggestion(metadata, priority, supplier);
    }

    public static final class PermissionServiceSuggestion {
        private final PluginMetadata metadata;
        private final int priority;
        private final Supplier<PermissionsService> supplier;

        private PermissionServiceSuggestion(PluginMetadata metadata, int priority, Supplier<PermissionsService> supplier) {
            this.metadata = metadata;
            this.priority = priority;
            this.supplier = supplier;
        }

        public PluginMetadata metadata() {
            return this.metadata;
        }

        public int priority() {
            return this.priority;
        }

        public Supplier<PermissionsService> supplier() {
            return this.supplier;
        }
    }
}

